.TH DCINTRO 1 "30 Jul 2021" "DICOM PS3" "DICOM PS3 - Introduction and Options"
.SH NAME
dcintro \- ACR/NEMA DICOM PS3 ... Introduction and options
.SH SYNOPSIS
.HP 10
.B dcxxxx
.so man1/gen.so
.so man1/optin.so
.so man1/optout.so
.SH DESCRIPTION
.LP
The options described are common to all tools and conversions as necessary when either DICOM input or output or both are supported.
.LP
Though input may be redirected from standard input or standard output, in general the ability to seek is required on input, and if this is not supported, as in input from a pipe, the operation will fail.
.LP
Under normal circumstances, utilities that read DICOM or older ACR/NEMA
input files, whether a meta-information header is present or not, should
be able to automatically determine the appropriate Transfer Syntax.
.LP
For utilities that write DICOM output,  the default
behaviour is to write a meta-information header and preamble, and
hence produce files that are compliant with DICOM PS 3.10. No other files
can claim conformance to the standard, and even then compliance with a
specific Media Application Profile is still required. It may be useful
to suppress the meta-header if it is required to construct datasets
contained temporarily within files prior to exchange using the DICOM
network protocol.
.LP
For utilities that write DICOM output, various attributes may be manually
deleted or replaced after the initial DICOM dataset is read or generated.
Various options exist to replace such attributes before or after the image
pixel data encoding is established, hence either incorrect attributes can
be corrected, or the encoding can be changed.
.SH OPTIONS
.LP
Input options are:
.TP
.BI \-if|\-input-file|< " name"
.RS
.RE
.TP
.B \-input-nometa
.RS
Input does not contain a meta-information header and preamble.
Needed only when the automatic determination of input Transfer Syntax fails.
When specified, suppresses check for the presence of a meta-information
header and will use either the transfer syntax specified by \-input-ts " uid"
or the byte order and implicit or explicit vr, otherwise these are automatically
determined from the dataset (guessed).
.RE
.TP
.B \-input-nolengthtoend
.RS
Ignore the length to end value, if present. Normally the reading stops
after length to end bytes have been read and any trailing padding present
is ignored.
.RE
.TP
.B \-ignoreoutofordertags
.RS
Ignore tags that are incorrectly out of order and keep reading the dataset.
Useful for debugging invalid data sets, but may cause parser to get lost if
problem is not really out of order tags. Also enables parsing past various
other encoding issues that are not related to tag order.
.RE
.TP
.B \-usvrlutdata
.RS
If the VR for the LUT Data attribute is not explicitly specified, then a US
(rather than the default OW) VR will be used; can be used to convert one
form to another by converting to implicit first and then using this option .
.RE
.TP
.BI \-input-ts " uid"
.RS
Use the input Transfer Syntax specified by the UID.
Needed only when the automatic determination of input Transfer Syntax fails.
Will be used to set the transfer syntax for the meta-header (if present) rather
than the dataset unless \-input-nometa is also specified.
.RE
.TP
.B \-input-default
.RS
Use the default Implicit VR Little Endian Transfer Syntax for input.
Needed only when the automatic determination of input Transfer Syntax fails.
.RE
.TP
.B \-input-byteorder|-input-endian " big|little"
.RS
Select an uncompressed input Transfer Syntax that uses the specified
byteorder. Requires that the input Value Representation also be
specified.
Needed only when the automatic determination of input Transfer Syntax fails.
.RE
.TP
.B \-input-vr " implicit|explicit"
.RS
Select an uncompressed input Transfer Syntax that uses the specified
Value Representation. Requires that the input byteorder also be
specified.
Needed only when the automatic determination of input Transfer Syntax fails.
.RE
.LP
Output options are:
.TP
.BI \-of|\-output-file|> " name"
.RS
.RE
.TP
.B \-n|\-nometa|\-output-nometa
.RS
Don't write an output meta-information header and preamble.
.RE
.TP
.B \-justmeta|\-output-justmeta
.RS
Write only a meta-information header and preamble, and not the
data set itself.
.RE
.TP
.B \-implicitmeta|\-output-implicitmeta
.RS
Use the obsolete pre-standard draft Implicit VR Little Endian
Transfer Syntax for the meta-information header.
.RE
.TP
.BI \-ts|\-output-ts|\-output-transfersyntax " uid"
.RS
Use the output Transfer Syntax specified by the UID.
.RE
.TP
.B \-output-default
.RS
Use the default Implicit VR Little Endian Transfer Syntax for output.
This is the default mode anyway, and the option is redundant.
.RE
.TP
.B \-output\-byteorder|\-output\-endian " big|little"
.RS
Select an uncompressed output Transfer Syntax that uses the specified
byteorder. Requires that the output Value Representation also be
specified.
.RE
.TP
.B \-output-vr " implicit|explicit"
.RS
Select an uncompressed output Transfer Syntax that uses the specified
Value Representation. Requires that the output byteorder also be
specified.
.RE
.TP
.BI \-s|\-stamp " uiddatetimestamp"
.RS
When UIDs are automatically generated, they incorporate the current
date and time to ensure uniqueness. If two invocations of a utility
are to generate the same UIDs, for example for two images of a series
to share a common SeriesInstanceUID, then the current date and time
may be replaced in the generated uid by the explicitly specified
value. This option is also useful for regression testing to ensure
that the output matches that of a previous invocation, without being
affected by the current date and time. A typical value to use for
a stamp shared between multiple images in the same study would
be "`date '+%Y%m%d%H%M%S'`.$$".
.RE
.TP
.B \-addlengths
.RS
Add group length attributes to every group.
Normally the group length is only generated for the meta-information
header group, where it is mandatory. These have been retired by DICOM
3.0 but are often checked by applications, and are sometimes required
by older ACR/NEMA applications. Note that
LengthToEnd is not added by this option unless \-addlengthtoend is
also specified.
.RE
.TP
.B \-addlengthtoend
.RS
Add the LengthToEnd attribute. This has been retired by DICOM
3.0 but are often checked by applications, and are sometimes required
by older ACR/NEMA applications.
.RE
.TP
.B \-tiff|\-tif
.RS
Add a TIFF header in the DICOM Meta-information preamble, which points
to a TIFF Image File Directory (IFD) at the end of the dataset in the
DataSetTrailingPadding Attribute after the PixelData attribute. This
allows the DICOM file to be a 'dual-personality' file, sharing the
pixel data with two formats, and allowing both TIFF and DICOM readers
to handle the image.
.RE
.TP
.B \-removeprivate
.RS
Remove any private attributes present, ie. all those in odd groups.
.RE
.TP
.B \-removeinstanceuid
.RS
Remove any existing SOPInstanceUID. This is generally a prelude to
automatically generating a new one, which will happen unless
\-noadddicom is also specified.
.RE
.TP
.B \-noadddicom
.RS
Suppress the automatic insertion of SOP Instance UIDs and SOP Class
UIDs where they are missing and can be meaningfully guessed at given
the presence and values of other attributes. For a composite image
object instance, the StudyID, SeriesNumber and ImageNumber will be
used together with the date and time or explicit stamp (see \-stamp)
to generate StudyInstanceUID, SeriesInstanceUID and SOPInstanceUID.
The SOPClassUID will be guessed at from Modality if not ambiguous.
There is no guarantee that a complete IOD will be generated in this
manner, it is just a best effort when required attributes are
missing, and has no effect on an exisiting complete IOD.
.RE
.TP
.B \-nodisclaimer
.RS
Suppress insertion of the 'for investigational use only'
disclaimer in the ImageComments attribute.
.RE
.TP
.B \-disambiguateseriesbydescription
.RS
When inserting Series Instance UIDs, use not just the Series Number but also the characters in the Series
Description to (try to) build a value that disambiguates series with the same number but different descriptions.
.RE
.TP
.BI \-d|\-delete " deletekeyword"
.RS
Delete the named attribute after the data set has been cleaned of old
metaheader attributes, UIDs (if requested) and private attributes (if
requested), but before automatic DICOM attributes (if not suppressed),
disclaimers (if not suppressed) and new metaheader (if not suppressed)
attributes have been added.
.RE
.TP
.BI \-r|\-replace|\-rb|\-replace\-before " replacekeyword values"
.RS
Replace or add the named attribute after the data set has been cleaned of old
metaheader attributes, UIDs (if requested) and private attributes (if
requested), but BEFORE automatic DICOM attributes (if not suppressed),
disclaimers (if not suppressed) and new metaheader attributes (if not
suppressed) have been added, and the output encoding transformations
have been established. Note that attributes related to image pixel encoding
changed at this point WILL affect actual image pixel data transformations,
and hence may be specified here to cause such transformations,
based on BitsAllocated, BitsStored and HighBit. Note that in order to
replace a value with a string that starts with a leading hyphen ('-')
that might otherwise be interpreted as another option, enter the value in
single quotes and preceded the hyphen with a space (which will later
be elided), eg. "-r Rescale Intercept ' -1024'".
.RE
.TP
.BI \-ra|\-replace\-after " replacekeyword values"
.RS
Replace or add the named attribute after 
automatic DICOM attributes (if not suppressed),
disclaimers (if not suppressed) and new metaheader attributes (if not
suppressed) have been added, but before group lengths (if requested)
have been added. Note that attributes related to image pixel encoding
changed at this point will have no effect on actual image pixel data
transformations, and hence may be specified here to correct such
attributes.
.RE
.TP
.BI \-version
.RS
Print a version string to stderr, and exit if there are no other arguments.
.RE
.SH ENVIRONMENT
.LP
\ 
.SH EXAMPLES
.TP
\n 
.SH FILES
.LP
\ 
.SH SEE ALSO
.LP
\ 
.SH AUTHOR
.LP
Copyright (c) 1993-2024, David A. Clunie DBA PixelMed Publishing. All rights reserved.
.SH BUGS
.LP
Though redirection from a file on standard input should work, certain libraries give incorrect results, rather than actually failing with a seek error ... this has been observed with libg++ 2.7.0 and is a bit worrying. The use of standard input redirection has not been removed however, for use in those environments in which it does work.
.LP
One cannot specify a zero length string value for replacements on the
command line. One can specify a string with a single space byte, which
then gets removed as trailing zeroes are removed, so one can make zero
length type 2 attributes.
